package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingSpaceDao;
import com.pcloud.book.advertising.dto.AdvertisingSpaceDTO;
import com.pcloud.book.advertising.entity.AdvertisingSpace;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description 广告位数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingSpaceDao")
public class AdvertisingSpaceDaoImpl extends BaseDaoImpl<AdvertisingSpace> implements AdvertisingSpaceDao {

    /**
     * 获取广告位信息
     */
    @Override
    public AdvertisingSpaceDTO getDTOById(Long adId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), adId);
    }

    /**
     * 书刊广告位明细
     */
    @Override
    public List<AdvertisingSpaceDTO> advertisingDetail4Book(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("advertisingDetail4Book"), paramMap);
    }

    /**
     * 微信群广告位明细
     */
    @Override
    public List<AdvertisingSpaceDTO> advertisingDetail4WechatGroup(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("advertisingDetail4WechatGroup"), paramMap);
    }

    /**
     * 广告主广告位明细
     */
    @Override
    public List<AdvertisingSpaceDTO> advertisingDetail4Master(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("advertisingDetail4Master"), paramMap);
    }

    /**
     * 获取书刊下的广告位列表
     */
    @Override
    public List<AdvertisingSpaceDTO> getDTOByBookId(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("getDTOByBookId"), paramMap);
    }

    @Override
    public List<AdvertisingSpace> getUnConvertFile(String adDetailFileId) {
        return getSessionTemplate().selectList(getStatement("getUnConvertFile"),adDetailFileId);
    }

    @Override
    public void updateByFileId(AdvertisingSpace advertisingSpace) {
        getSessionTemplate().update(getStatement("updateByFileId"),advertisingSpace);
    }

    @Override
    public void updateTestStatus(Boolean isTest, Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("isTest", isTest);
        getSessionTemplate().update(getStatement("updateTestStatus"), map);
    }

    @Override
    public List<AdvertisingSpace> getByIds(List<Long> ids) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        return getSessionTemplate().selectList(getStatement("getByIds"), map);
    }

    @Override
    public List<Long> getAdIdsByMasterId(Long masterId) {
        return getSessionTemplate().selectList(getStatement("getAdIdsByMasterId"),masterId);
    }

    @Override
    public List<Long> getAdIdsByCPAId(Long cpaId) {
        return getSessionTemplate().selectList(getStatement("getAdIdsByCPAId"), cpaId);
    }

    @Override
    public void updateCPAId(Long adId, Long cpaId) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", adId);
        map.put("cpaId", cpaId);
        getSessionTemplate().update(getStatement("updateCPAId"), map);
    }

    @Override
    public List<AdvertisingSpace> getCPASpaceList() {
        return getSessionTemplate().selectList(getStatement("getCPASpaceList"));
    }
}
