package com.pcloud.book.copyright.service.impl;

import com.pcloud.book.book.dto.BookAuthServeStatusParam;
import com.pcloud.book.copyright.biz.BookAuthServeBiz;
import com.pcloud.book.copyright.dto.BookAuthServerDTO;
import com.pcloud.book.copyright.dto.QrcodeAuthServeDTO;
import com.pcloud.book.copyright.service.BookAuthServeService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 11:16
 */
@RestController("bookAuthServeService")
@RequestMapping("bookAuthServeService")
public class BookAuthServeServiceImpl implements BookAuthServeService {

    @Autowired
    private BookAuthServeBiz bookAuthServeBiz;

    @Override
    @PostMapping("listIsOpen4ServeIds")
    public ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4ServeIds(@RequestBody BookAuthServeStatusParam bookAuthServeStatusParam) throws BizException {
        Map<String, Boolean> isOpen4ServeIds = null;
        if (bookAuthServeStatusParam != null) {
            isOpen4ServeIds = bookAuthServeBiz.isSetServeAuth(bookAuthServeStatusParam.getBookId(), bookAuthServeStatusParam.getChannelId(), bookAuthServeStatusParam.getAdviserId(), bookAuthServeStatusParam.getServeIds());
        }
        return ResponseHandleUtil.toResponse(isOpen4ServeIds);
    }

    @Override
    @PostMapping("listIsOpen4ServeIdsAndQrcode")
    public ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4ServeIdsAndQrcode(@RequestBody QrcodeAuthServeDTO qrcodeAuthServeDTO) throws BizException {
        Map<String, Boolean> isOpen4ServeIds = null;
        if (qrcodeAuthServeDTO != null) {
            isOpen4ServeIds = bookAuthServeBiz.listIsOpen4ServeIdsAndQrcode(qrcodeAuthServeDTO.getSceneId(), qrcodeAuthServeDTO.getServeIds());
        }
        return ResponseHandleUtil.toResponse(isOpen4ServeIds);
    }

    @Override
    @PostMapping("listIsOpen4ServeIdsAndBookId")
    public ResponseEntity<ResponseDto<Map<String, Boolean>>> listIsOpen4ServeIdsAndBookId(@RequestBody BookAuthServerDTO bookAuthServerDTO)
            throws BizException {
        Map<String, Boolean> isOpen4ServeIds = null;
        if (bookAuthServerDTO != null && !bookAuthServerDTO.check()) {
            isOpen4ServeIds = bookAuthServeBiz.listIsOpen4ServeIdsAndBookId(bookAuthServerDTO.getBookId(), bookAuthServerDTO.getAdviserId(), bookAuthServerDTO.getChannelId(), bookAuthServerDTO.getServeIds());
        }
        return ResponseHandleUtil.toResponse(isOpen4ServeIds);
    }
}
