package com.pcloud.book.custom.biz;

import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.custom.vo.AddBookNameVO;
import com.pcloud.book.custom.vo.AddCustomPlan4UserVO;
import com.pcloud.book.custom.vo.AddSuggestionVO;
import com.pcloud.book.custom.vo.CustomPlanModuleVO;
import com.pcloud.book.custom.vo.CustomPlanPaperVO;
import com.pcloud.book.custom.vo.EditCustomPlanModuleVO;
import com.pcloud.book.custom.vo.ModuleSuggestionVO;
import com.pcloud.book.custom.vo.SuggestionListVO;
import com.pcloud.book.custom.vo.UserBookServiceVO;
import com.pcloud.common.page.PageBeanNew;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface CustomPlanBiz {

    Integer createCustomPlan(CustomPlan customPlan);

    void copyCustomPlan(Integer planId);

    void updateCustomPlan(CustomPlan customPlan);

    CustomPlan getCustomPlanById(Integer planId);

    void deleteCustomPlanById(Integer planId);

    PageBeanNew<CustomPlan> listCustomPlanByPage(Integer currentPage, Integer numPerPage, String content, Integer useState, Integer hasPdf);

    void editCustomPlanModule(EditCustomPlanModuleVO editCustomPlanModuleVO);

    List<CustomPlanModuleVO> getCustomPlanModule(Integer planId);

    PageBeanNew<CustomPlanPaperVO> listPlanPaperByPage(Integer currentPage, Integer numPerPage, Integer paperState, String content);

    Map<String, Object> getShortLinkUrl(Long appId, Long productId, String linkUrl);

    PageBeanNew<SuggestionListVO> listSuggestion4Plan(Integer currentPage, Integer numPerPage, String startTime, String endTime, String search, Integer planId);

    List<ModuleSuggestionVO> getSuggestionInfo(Integer batchId, Integer planId);

    Integer addSuggestion4Module(AddSuggestionVO addSuggestionVO);

    Integer addCustomPlan4User(AddCustomPlan4UserVO addCustomPlan4UserVO);

    public Boolean getUserInputPermission(String userWxId, Integer planId);

    List<Integer> getPlanIdListByUser(String wxId);

    Integer addBookNameAndServiceType(AddBookNameVO addBookNameVO);

    AddBookNameVO getUserBookAdnServiceType(String wxId, String robotWxId, Integer type);

    UserBookServiceVO getUserBookServiceById(Long userBookServiceId);
}
