package com.pcloud.book.group.facade;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Api(description = "社区群应用作品")
public interface BookGroupAppFacade {


    @ApiOperation("根据社群码id查询所挂资源统计")
    @GetMapping("getBookGroupAppDTOSByBookGroupId")
    ResponseDto<?> getBookGroupAppDTOSByBookGroupId(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") Long bookGroupId,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws PermissionException;

    @ApiOperation("根据社群码id导出所挂资源统计")
    @GetMapping("exportBookGroupAppDTOSByBookGroupId")
    ResponseDto<?> exportBookGroupAppDTOSByBookGroupId(
            @RequestHeader("token") String token,
            @RequestParam("bookGroupId") Long bookGroupId
    ) throws PermissionException;

}
