package com.pcloud.book.mq.delay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pcloud.book.personalstage.biz.PersonalStageBiz;
import com.pcloud.book.personalstage.biz.PersonalStageJumpBiz;
import com.pcloud.book.personalstage.constant.PersonalStageConstant;
import com.pcloud.common.core.mq.DelayQueueDTO;
import com.pcloud.common.core.mq.MQQueueConstants;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;

import lombok.extern.slf4j.Slf4j;

/**
 * 监听延时队列
 */
@Slf4j
@Component
@RabbitListener(queues = MQQueueConstants.BOOK_IMMEDIATE_QUEUE_FOR_DELAY)
public class DelayReceiver {

    @Autowired
    private PersonalStageBiz personalStageBiz;
    @Autowired
    private PersonalStageJumpBiz personalStageJumpBiz;

    @RabbitHandler
    public void onMessage(DelayQueueDTO dto) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("收到延时消息：{} 时间：{}", dto, sdf.format(new Date()) + " Delay sent.");
        if (dto==null){
            log.info("收到延时消息为空！");
            return;
        }
        if (PersonalStageConstant.PERSONALSTAGE_DELAY_WAKEUP.equals(dto.getType())){
            personalStageBiz.dealDelayWakeup(dto);
        } else if (PersonalStageConstant.PERSONALSTAGE_DELAY_FUSING.equals(dto.getType())) {
            personalStageBiz.dealDelayFusingFinish(dto);
        } else if (PersonalStageConstant.PERSONALSTAGE_DELAY_LINKUP.equals(dto.getType())) {
            personalStageJumpBiz.dealDelayLinkup(dto);
        } else if (PersonalStageConstant.PERSONALSTAGE_DELAY_PROGRESS.equalsIgnoreCase(dto.getType())) {
            personalStageJumpBiz.delayProgress(dto);
        } else if (PersonalStageConstant.PERSONALSTAGE_DELAY_PAPER.equalsIgnoreCase(dto.getType())) {
            personalStageJumpBiz.delayPaper(dto);
        }
    }


}
