package com.pcloud.book.pcloudkeyword.biz;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.dto.PcloudTdDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudClassifyTemplate;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotResponseVO;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;

import java.util.List;
import java.util.Map;

public interface PcloudRobotBiz {

    /**
     * 校验小号真是状态
     */
    void changeRobotRealStatus(String wxId, Integer status);

    void createPcloudRobot(PcloudRobot pcloudRobot);

    void updatePcloudRobot(PcloudRobot pcloudRobot);

    void updatePcloudRobotByWxId(PcloudRobot pcloudRobot);

    void updateRobotState(Long id, Integer state);

    PageBeanNew<PcloudRobot> getPcloudRobotList(Integer classifyId, String nickName, Integer currentPage, Integer numPerPage);

    void batchUpdatePcloudRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList);

    PcloudRobot getPcloudRobot(Long id);

    void sendWelcomeReply(String robotWxId, String userWxId, String ip);

    void relateKeywordClassify(Long pcloudRobotId, Long keywordClassifyId);

    PcloudRobot getPcloudRobotByType(Integer robotType);

    PageBeanNew<PcloudClassifyTemplate> listClassifyTemplate(Integer classifyId, Integer currentPage, Integer numPerPage);

    void openTemplate(Integer classifyId, Long templateId);

    void uploadTemplateAudio(PcloudClassifyTemplate classifyTemplate);

    PcloudClassifyTemplate getTemplateByClassifyId(Integer classifyId);

    Map<String, RobotClassifyDTO> mapByIds4Classify(List<String> robotIds);

    List<RobotClassifyDTO> getAllPcloudRobot();

    PcloudRobot getPcloudRobotByWxId(String robotId);

    void editPcloudTd(PcloudTdDTO pcloudTdDTO);

    PcloudTdDTO getPcloudTdInfo();

    void handlePcloudTdReply(SendTextDTO sendTextDTO);

    void updateUserTdState(String robotWxId, String userWxId, Integer tdState);

    Integer getUserTdState(String robotWxId, String userWxId);

    String getTdKeyword();

    void copyRobotWelcome(String sourceRobotWxId, String targetRobotWxId);

    void copyRobotConfiguration(String sourceRobotWxId, String targetRobotWxId);

    /**
     * 根据分类获取个人号
     * @return
     */
    PageBeanNew<PcloudRobotResponseVO> listSelfRobotByClassify(Integer largeTemplet, Long classifyId, String keyword, Integer currentPage, Integer numPerPage);

    PageBeanNew<PcloudRobot> listNoClassifyRobot(Integer currentPage, Integer numPerPage);

    void setClassifyRobot(String wxId, Integer classifyId);

    void removeClassifyRobot(String wxId, Integer classifyId);

    PageBeanNew<PcloudRobot> listPcloudRobot4Service(Integer classifyId, String nickName, Integer currentPage, Integer numPerPage);

    /**
     * 生成技能链接
     */
    public String generateLinkBySkill(Long skillId, String userWxId, String robotId);

    /**
     * 生成图书链接
     */
    public String generateLinkByBook(Long bookId, Long adviserId, Long channelId, String userWxId, String robotId);

    /**
     * 生成应用/作品链接
     */
    public String generateLinkbyAppProduct(String link, Long serveId, String serveType, String userWxId, String robotId);

    List<String> getPcloudRobotByTypes(List<Integer> classifyIds);

    void updateUniqueNumber(Long id, String uniqueNumber);

    List<String> getPcloudRobotByClassify(Integer classifyId);

    void handleMiniAppQr();
}
