package com.pcloud.book.personalstage.service.impl;

import com.pcloud.book.personalstage.biz.PersonalStageBiz;
import com.pcloud.book.personlstage.dto.UserReplaceCodeDTO;
import com.pcloud.book.personlstage.service.PersonalStageService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ResponseHandleUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController("personalStageService")
@RequestMapping("personalStageService")
public class PersonalStageServiceImpl implements PersonalStageService {

    @Autowired
    private PersonalStageBiz personalStageBiz;

    @ApiOperation("创建用户替换记录")
    @PostMapping("createUserReplaceCode")
    @Override
    public void createUserReplaceCode(
            @RequestBody @ApiParam("用户替换记录") UserReplaceCodeDTO userReplaceCodeDTO
    ) throws BizException {
        personalStageBiz.createUserReplaceCode(userReplaceCodeDTO);
    }

    @ApiOperation("获取用户替换map")
    @GetMapping("getUserReplaceMap")
    @Override
    public ResponseEntity<ResponseDto<Map<String,String>>> getUserReplaceMap(@RequestParam("wxId") @ApiParam("用户id") String wxId, @RequestParam("robotId") @ApiParam("机器人id") String robotId){
        return ResponseHandleUtil.toResponse(personalStageBiz.getUserReplaceMap(wxId,robotId));
    }
}
