package com.pcloud.book.advertising.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingSettlementMethodDao;
import com.pcloud.book.advertising.dto.AdvertisingSettlementMethodDTO;
import com.pcloud.book.advertising.entity.AdvertisingSettlementMethod;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告结算方式数据访问层接口实现类
 * Created by PENG on 2019/4/26.
 */
@Repository("advertisingSettlementMethodDao")
public class AdvertisingSettlementMethodDaoImpl extends BaseDaoImpl<AdvertisingSettlementMethod> implements AdvertisingSettlementMethodDao {

    /**
     * 删除广告主配置的结算方式
     */
    @Override
    public long deleteByMasterId(Long masterId) {
        return super.getSqlSession().delete(getStatement("deleteByMasterId"), masterId);
    }

    /**
     * 获取广告主配置的结算方式列表
     */
    @Override
    public List<AdvertisingSettlementMethodDTO> getByMasterId(Long masterId) {
        return super.getSqlSession().selectList(getStatement("getByMasterId"), masterId);
    }

    /**
     * 获取广告位的结算方式
     */
    @Override
    public AdvertisingSettlementMethodDTO getByMasterIdAndAdId(Long masterId, Long adId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("masterId", masterId);
        paramMap.put("adId", adId);
        return super.getSqlSession().selectOne(getStatement("getByMasterIdAndAdId"), paramMap);
    }
}
