package com.pcloud.book.appeal.dao.impl;

import com.pcloud.book.appeal.dao.BookAppealResultDao;
import com.pcloud.book.appeal.dto.BookAppealResultDto;
import com.pcloud.book.appeal.entity.BookAppealResult;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/** 
  *  书刊申诉结果数据访问层实现类
  *  @author:lili
  *  @date 创建时间：2017年3月30日 下午4:17:11 
  *  @version 1.0 
  *  @return  
  */
@Repository("bookAppealResultDao")
public class BookAppealResultDaoImpl extends BaseDaoImpl<BookAppealResult> implements BookAppealResultDao{

    @Override
    public List<BookAppealResultDto> getAppealResult(Long bookAppealId) {
        return this.getSqlSession().selectList(this.getStatement("getAppealResult"), bookAppealId);
    }
}
