package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.UpdateAppletGroupManageDTO;
import com.pcloud.book.applet.entity.AppletGroupManage;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * 学舍群管理(AppletGroupManage)表服务接口
 *
 * @author zyq
 * @since 2020-04-01 14:05:41
 */
public interface AppletGroupManageBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletGroupManage getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(String name, Integer currentPage, Integer numPerPage);

    /**
     * 任意门
     * @param recommend
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew getList4Applet(Integer recommend, Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param groupActivityIds
     * @return 主键
     */
    void insert(List<Long> groupActivityIds);

    /**
     * 修改数据
     *
     * @param updateAppletGroupManageDTO 实例对象
     */
    void update(UpdateAppletGroupManageDTO updateAppletGroupManageDTO);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);
}