package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletBannerBiz;
import com.pcloud.book.applet.dao.AppletBannerDao;
import com.pcloud.book.applet.dto.AppletBannerDTO;
import com.pcloud.book.applet.entity.AppletBanner;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 小程序banner
 */
@Component
public class AppletBannerBizImpl implements AppletBannerBiz {

    @Autowired
    private AppletBannerDao appletBannerDao;


    @Override
    public Long addBanner(AppletBanner appletBanner) {
        Integer seq = appletBannerDao.getMaxSeq();
        appletBanner.setSeq(seq+1);
        appletBanner.setShowState(false);
        appletBannerDao.insert(appletBanner);
        return appletBanner.getId();
    }

    @Override
    public void updateBanner(AppletBanner appletBanner) {
        if (null==appletBanner.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少id");
        }
        appletBannerDao.update(appletBanner);
    }

    @Override
    public void deleteBanner(Long id) {
        appletBannerDao.deleteById(id);
    }

    @Override
    public AppletBannerDTO getBannerById(Long id) {
        AppletBanner appletBanner = appletBannerDao.getById(id);
        AppletBannerDTO appletBannerDTO = new AppletBannerDTO();
        if (null != appletBanner){
            BeanUtils.copyProperties(appletBanner,appletBannerDTO);
        }
        return appletBannerDTO;
    }

    @Override
    public PageBeanNew<AppletBannerDTO> listBanner(Integer currentPage, Integer numPerPage, Boolean showState) {
        Map<String,Object> map = new HashMap<>();
        map.put("showState", showState);
        PageBeanNew<AppletBannerDTO> pageBeanNew = appletBannerDao.listPageNew(
                new PageParam(currentPage,numPerPage), map, "listBanner");
        return pageBeanNew;
    }
}
