/**
 * 
 */
package com.pcloud.book.book.biz;

import java.util.List;

import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.book.book.entity.BookApp;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:58:54
 * @版本：1.0
 */
public interface BookAppBiz {

	/**
	 * 添加书籍应用关联关系
	 * 
	 * @param bookApp 书籍关联应用实体
	 * @throws BizException
	 */
	public void create(BookApp bookApp) throws BizException;

	/**
	 * 删除作品应用关联关系
	 * 
	 * @param bookApp 书籍关联应用标识
	 * @return
	 */
	public void delete(Long bookAppId) throws BizException;	
	
	/**
	 * 书籍标识删除作品应用关联关系
	 * 
	 * @param bookId 图书标识
	 * @throws BizException
	 */
	public void deleteByBook(Long bookId) throws BizException;

	/**
	 * 批量删除作品应用关联关系
	 * 
	 * @param bookIds 图书标识列表
	 * @throws BizException
	 */
	public void deleteByBooks(List<Long> bookIds) throws BizException;

	/**
	 * 获取书籍和应用关联关系
	 * 
	 * @param bookApp 书籍关联应用实体
	 * @return
	 */
	public List<BookAppDto> listBaseById(BookApp bookApp) throws BizException;	

	/**
	 * 获取书籍关联的应用（过滤已失效的应用或审核不通过的应用）
	 * 
	 * @param bookId 图书标识
	 * @param adviserId 编辑标识
	 * @param channelId 渠道标识
	 * @return
	 */
	public List<BookAppDto> getListById(Long bookId, Long adviserId, Long channelId) throws BizException;

	/**
	 * 根据书籍和渠道删除书籍应用关联信息
	 * 
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 * @return
	 */
	public void deleteByBookAndChannel(Long bookId, Long channelId) throws BizException;

	/**
	 * 获取书籍关联应用
	 * @param bookId 图书标识
	 * @param adviserId 编辑标识
	 * @param channelId 渠道标识
	 * @return
	 */
	public List<BookAppDto> getListById4Adviser(Long bookId, Long adviserId, Long channelId);	
	
	/**
	 * 获取图书关联应用个数
	 * @param adviserId 编辑标识
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 * @return
	 */
	public Integer getAppCount(Long adviserId, Long bookId, Long channelId);
	
	/**
	 * 批量创建应用与书籍关联
	 * @param bookIds 图书标识列表
	 * @param channelId 渠道标识
	 * @param appId 应用标识
	 * @param adviserId 编辑标识
	 */
	public void createBatch(List<Long> bookIds, Long channelId, Long appId, Long adviserId);

	/**
	 * 修改书籍应用关系 1删除 0未删除
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 * @param status 状态
	 * @param adviserId 编辑标识
	 */
	public void updateBookAppStatus(Long bookId, Long channelId, Integer status, Long adviserId);
}
