package com.pcloud.book.clock.entity;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:52
 * @Version 1.0
 */
public class BookClockInfo extends BaseEntity {

    private static final long serialVersionUID = 8385194135258376669L;

    @ApiModelProperty("bookClockInfoId")
    private Long bookClockInfoId;

    @ApiModelProperty("作品/应用ID")
    private Long originId;

    @ApiModelProperty("作品/应用类型")
    private String originType;

    @ApiModelProperty("作品/应用标题")
    private String originTitle;

    @ApiModelProperty("作品/应用封面图")
    private String originImg;

    @ApiModelProperty("编号")
    private String uniqueNumber;

    @ApiModelProperty("渠道ID")
    private Long channelId;

    @ApiModelProperty("社群码ID集合")
    private List<Long> bookGroupIdList;

    @ApiModelProperty("分类ID集合")
    private List<Long> classifyIdList;

    @ApiModelProperty("关键词集合")
    private List<BookClockKeyword> bookClockKeywordList;

    @ApiModelProperty("是否开启提醒")
    private Boolean isNotice;

    @ApiModelProperty("提醒时间")
    private String noticeTime;

    @ApiModelProperty("提醒内容")
    private String noticeContent;

    @ApiModelProperty("修改类型")
    private String updateType;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public String getOriginTitle() {
        return originTitle;
    }

    public void setOriginTitle(String originTitle) {
        this.originTitle = originTitle;
    }

    public String getOriginImg() {
        return originImg;
    }

    public void setOriginImg(String originImg) {
        this.originImg = originImg;
    }

    public String getUniqueNumber() {
        return uniqueNumber;
    }

    public void setUniqueNumber(String uniqueNumber) {
        this.uniqueNumber = uniqueNumber;
    }

    public List<Long> getBookGroupIdList() {
        return bookGroupIdList;
    }

    public void setBookGroupIdList(List<Long> bookGroupIdList) {
        this.bookGroupIdList = bookGroupIdList;
    }

    public List<Long> getClassifyIdList() {
        return classifyIdList;
    }

    public void setClassifyIdList(List<Long> classifyIdList) {
        this.classifyIdList = classifyIdList;
    }

    public List<BookClockKeyword> getBookClockKeywordList() {
        return bookClockKeywordList;
    }

    public void setBookClockKeywordList(List<BookClockKeyword> bookClockKeywordList) {
        this.bookClockKeywordList = bookClockKeywordList;
    }

    public Boolean getIsNotice() {
        return isNotice;
    }

    public void setIsNotice(Boolean isNotice) {
        this.isNotice = isNotice;
    }

    public String getNoticeTime() {
        return noticeTime;
    }

    public void setNoticeTime(String noticeTime) {
        this.noticeTime = noticeTime;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getNoticeContent() {
        return noticeContent;
    }

    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }

    public String getUpdateType() {
        return updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }
}
