package com.pcloud.book.consumer.comment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.comment.product.dto.CommentDisplayDto;
import com.pcloud.comment.product.service.CommentService;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * @描述：评论消息
 * @作者：lili
 * @创建时间：2016年11月18日,上午9:56:03
 * @版本：1.0
 */
@Component("commentConsr")
public class CommentConsr {
	
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(CommentConsr.class);

	@Autowired
	private CommentService commentService;

	/**
	 * 获取商品好评度
	 */
	public Map<Long, CommentDisplayDto> getCommentFavorableRateByProductIds(List<Long> productIds) throws BizException {
		LOGGER.info("获取商品好评度,<PARAM>.[productIds]=" + productIds);
          if(productIds == null || productIds.isEmpty()){
        	  return null;
          }
        Map<Long, CommentDisplayDto> commentMap = new HashMap<>();
		try {
			commentMap = ResponseHandleUtil.parseMapResponse(commentService.getCommentFavorableRateByProductIds(productIds), Long.class, CommentDisplayDto.class);
		} catch (Exception e) {
			LOGGER.error("获取商品好评度,<ERROR>.[commentService.getCommentFavorableRateByProductIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取商品好评度失败~!");
		}
		return commentMap;
	}


}
