package com.pcloud.book.consumer.feedback;


import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.feedback.feedback.service.FeedBackService;
import com.pcloud.feedback.paper.dto.PaperAndQuestionDto;
import com.pcloud.feedback.paper.dto.PaperDto;
import com.pcloud.feedback.paper.service.PaperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("feedbackConsr")
public class FeedbackConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackConsr.class);

	@Autowired
	private PaperService paperService;
	@Autowired
	private FeedBackService feedBackService;
	
	
	/**
	 * 获取反馈问卷信息
	 */
	public Map<Long, PaperDto> getPaperListByIds(List<Long> paperIds) throws BizException {
		LOGGER.info("获取反馈问卷信息[paperService.getPaperListByIds],参数列表[paperIds]:" + paperIds);
		Map<Long, PaperDto> paperDtoMap =  new HashMap<>();
		if (ListUtils.isEmpty(paperIds)) {
			return paperDtoMap;
		}
		try {
			paperDtoMap = ResponseHandleUtil.parseMapResponse(paperService.getPaperListByIds(paperIds), Long.class, PaperDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取反馈问卷信息[paperService.getPaperListByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取反馈问卷信息[paperService.getPaperListByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "获取反馈问卷信息失败~!");
		}
		return paperDtoMap;
	}

	/**
	 * 根据状态获取问卷ID
	 */
	public List<Long> getPaperIdsByState(Integer state) throws BizException {
		LOGGER.info("根据状态获取问卷ID[paperService.getPaperIdsByState],参数列表[state]:" + state);
		List<Long> paperIds =  new ArrayList<>();
		if (state == null) {
			return paperIds;
		}
		try {
			paperIds = ResponseHandleUtil.parseListResponse(paperService.getPaperIdsByState(state), Long.class);
		} catch (BizException e) {
			LOGGER.warn("根据状态获取问卷ID[paperService.getPaperIdsByState]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("根据状态获取问卷ID[paperService.getPaperIdsByState]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "根据状态获取问卷ID失败~!");
		}
		return paperIds;
	}

	@ParamLog("根据问卷id获取问卷基本信息")
	public PaperAndQuestionDto getPaperByPaperId(Long paperId){
		PaperAndQuestionDto questionDto = new PaperAndQuestionDto();
		try {
			questionDto=ResponseHandleUtil.parseResponse(feedBackService.getPaperByPaperId(paperId), PaperAndQuestionDto.class);

		}catch (Exception e){
			LOGGER.error("【feedBackService.getPaperByPaperId】调用失败"+e.getMessage(),e);
		}
		return questionDto;
	}


	@ParamLog("删除用户答卷记录")
    public void deleteUserAnswerRecord(List<Long> paperIds, String userWxId) {
		try {
			paperService.deleteUserAnswerRecord(paperIds, userWxId);

		}catch (Exception e){
			LOGGER.error("deleteUserAnswerRecord调用失败"+e.getMessage(),e);
		}
    }

}
