/**
 * 
 */
package com.pcloud.book.consumer.user;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.usercenter.party.agent.entity.Agent;
import com.pcloud.usercenter.party.common.service.PartyService;
import com.pcloud.usercenter.party.common.vo.PartyIdListVO;
import com.pcloud.usercenter.user.entity.UserLogin;
import com.pcloud.usercenter.user.service.UserLoginService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：当事人中间类
 * @作者：songx
 * @创建时间：2016年11月28日,下午3:46:01 @版本：1.0
 */
@Component("partyConsr")
public class PartyConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(PartyConsr.class);

	@Autowired
	private PartyService partyService;
	@Autowired
	private UserLoginService userLoginService;

	/**
	 * 批量获取代理基本信息
	 */
	public Map<Long, Agent> getAgentByPartyId(List<Long> partyIds, String roleCode) throws BizException {
		LOGGER.info("【用户中心(消)】批量获取代理基本信息,<START>.[partyIds]=" + partyIds.toString());
		if (ListUtils.isEmpty(partyIds)) {
			return null;
		}
		Map<Long, Agent> agentInfoMap = ResponseHandleUtil
				.parseMapResponse(partyService.getAgentByPartyId(partyIds, roleCode), Long.class, Agent.class);
		return agentInfoMap;
	}

	/**
	 * 获取平台端所有账号的用户名
	 */
	public Map<Long, String> getAllUserLoginName(Long partyId, String systemCode) throws BizException {
		LOGGER.info("【用户中心(消)】获取平台端所有账号的用户名,<START>.[partyId]=" + partyId + ", [systemCode]=" + systemCode);
		if (null == partyId || null == systemCode) {
			return new HashMap<>();
		}
		Map<Long, String> resultMap = ResponseHandleUtil
				.parseMapResponse(userLoginService.getAllUserLoginName(partyId, systemCode), Long.class, String.class);
		return resultMap;
	}

	@ParamLog(value = "获取测试账号", isAfterReturn = false)
	public PartyIdListVO getPartyIdList4Test() {
		ResponseEntity<ResponseDto<PartyIdListVO>> partyIdList = partyService.getPartyIdList4Test();
		PartyIdListVO partyIdListVO = ResponseHandleUtil.parseResponse(partyIdList, PartyIdListVO.class);
		return partyIdListVO;
	}


	@ParamLog("获取登录账号信息")
	public UserLogin getUserLoginInfo(Long loginId) {
		UserLogin userLogin = new UserLogin();
		try {
			userLogin = ResponseHandleUtil.parseResponse(userLoginService.getUserLoginInfo(loginId), UserLogin.class);
		} catch (Exception e) {
			LOGGER.error("【用户中心】获取平台端登录账号失败" + e.getMessage(), e);
		}
		return userLogin;
	}

	@ParamLog("根据partyId获取登录账号信息")
	public UserLogin getUserLoginInfoByPartyId(Long partyId,String systemCode, String isSystem){
		UserLogin userLogin = new UserLogin();
		try {
			userLogin = ResponseHandleUtil.parseResponse(userLoginService.getUserLoginInfo(partyId,systemCode,isSystem),UserLogin.class);

		}catch (Exception e){
			LOGGER.error("【用户中心】getUserLoginInfoByPartyId失败" + e.getMessage(), e);
		}
		return userLogin;
	}

}
