package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author lily
 * @date 2018/12/3 11:46
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SetLocationDescVO implements Serializable {

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("位置描述")
    private String locationDesc;

    @ApiModelProperty("书刊类型：0-现代纸书 1-社群书")
    private Integer authBookType;

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getLocationDesc() {
        return locationDesc;
    }

    public void setLocationDesc(String locationDesc) {
        this.locationDesc = locationDesc;
    }

    public Integer getAuthBookType() {
        return authBookType;
    }

    public void setAuthBookType(Integer authBookType) {
        this.authBookType = authBookType;
    }

    @Override
    public String toString() {
        return "SetLocationDescVO{" +
                "bookId=" + bookId +
                ", channelId=" + channelId +
                ", locationDesc='" + locationDesc + '\'' +
                ", authBookType=" + authBookType +
                '}';
    }
}
