package com.pcloud.book.custom.biz;

import com.pcloud.book.custom.dto.CustomPlanEmailDto;
import com.pcloud.book.custom.entity.CustomPlanEmail;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * 邮件提醒(CustomPlanEmail)表服务接口
 *
 * @author zyq
 * @since 2020-03-06 13:04:25
 */
public interface CustomPlanEmailBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param customPlanId
     * @return 实例对象
     */
    CustomPlanEmailDto getCustomPlanEmailByPlanId(Integer customPlanId);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param customPlanEmailDto 实例对象
     * @return 主键
     */
    Long sendCustomPlanEmail(CustomPlanEmailDto customPlanEmailDto);
}