package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description 特殊出版社对应小号表
 * @Author ruansiyuan
 * @Date 2019/11/8 11:33
 **/
@ApiModel("特殊出版社对应小号")
public class BookGroupAgentRecord extends BaseEntity {

    private static final long serialVersionUID = 7490525691947853419L;

    @ApiModelProperty("出版社id")
    private Long agentId;

    @ApiModelProperty("出版社名称")
    private String agentName;

    @ApiModelProperty("年级")
    private String grade;

    @ApiModelProperty("科目")
    private String subject;

    @ApiModelProperty("版本标签(确定小号用的)")
    private Integer target;

    @ApiModelProperty("小号id")
    private String altId;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("编辑id")
    private Long adviserId;


    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Integer getTarget() {
        return target;
    }

    public void setTarget(Integer target) {
        this.target = target;
    }

    public String getAltId() {
        return altId;
    }

    public void setAltId(String altId) {
        this.altId = altId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    @Override
    public String toString() {
        return "BookGroupAgentRecord{" +
                "agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", grade='" + grade + '\'' +
                ", subject='" + subject + '\'' +
                ", target=" + target +
                ", altId='" + altId + '\'' +
                ", bookGroupId=" + bookGroupId +
                ", adviserId=" + adviserId +
                "} " + super.toString();
    }
}
