package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/13 12:01
 **/
@ApiModel("社群书应用或作品")
public class BookGroupApp extends BaseEntity {

    private static final long serialVersionUID = 8087587834605088625L;

    @ApiModelProperty("作品或应用id")
    private Long serveId;

    @ApiModelProperty("应用或作品")
    private String serveType;

    @ApiModelProperty("类型来源（1欢迎语,2关键词,3群发,4配置资源）")
    private Integer originType;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("创建人")
    private Long createUser;

    public Long getServeId() {
        return serveId;
    }

    public void setServeId(Long serveId) {
        this.serveId = serveId;
    }

    public String getServeType() {
        return serveType;
    }

    public void setServeType(String serveType) {
        this.serveType = serveType;
    }

    public Integer getOriginType() {
        return originType;
    }

    public void setOriginType(Integer originType) {
        this.originType = originType;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @Override
    public String toString() {
        return "BookGroupApp{" +
                "serveId=" + serveId +
                ", serveType='" + serveType + '\'' +
                ", originType=" + originType +
                ", bookGroupId=" + bookGroupId +
                ", classifyId=" + classifyId +
                ", createUser=" + createUser +
                "} " + super.toString();
    }
}
