package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/5/6 15:56
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookGroupQrcodeStatisticVO implements Serializable {

    @ApiModelProperty("群标识")
    private Long groupQrcodeId;

    @ApiModelProperty("群标识")
    private String weixinGroupId;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("分类")
    private String classify;

    @ApiModelProperty("群名称")
    private String groupName;

    @ApiModelProperty("群总人数")
    private Integer groupUserNumber;

    @ApiModelProperty("累计进群人数")
    private Integer joinUserNumberTotal;

    @ApiModelProperty("今日进群人数")
    private Integer joinUserNumberToday;

    @ApiModelProperty("活跃人数")
    private Integer activeUserCount;

    @ApiModelProperty("总发言数")
    private Integer chatCount;

    @ApiModelProperty("总收益")
    private BigDecimal income;

    @ApiModelProperty("购买用户数")
    private Long buyUserNumber;

    @ApiModelProperty("购买次数")
    private Long buyCount;

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getWeixinGroupId() {
        return weixinGroupId;
    }

    public void setWeixinGroupId(String weixinGroupId) {
        this.weixinGroupId = weixinGroupId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getGroupQrcodeId() {
        return groupQrcodeId;
    }

    public void setGroupQrcodeId(Long groupQrcodeId) {
        this.groupQrcodeId = groupQrcodeId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getGroupUserNumber() {
        return groupUserNumber;
    }

    public void setGroupUserNumber(Integer groupUserNumber) {
        this.groupUserNumber = groupUserNumber;
    }

    public Integer getJoinUserNumberTotal() {
        return joinUserNumberTotal;
    }

    public void setJoinUserNumberTotal(Integer joinUserNumberTotal) {
        this.joinUserNumberTotal = joinUserNumberTotal;
    }

    public Integer getJoinUserNumberToday() {
        return joinUserNumberToday;
    }

    public void setJoinUserNumberToday(Integer joinUserNumberToday) {
        this.joinUserNumberToday = joinUserNumberToday;
    }

    public Integer getActiveUserCount() {
        return activeUserCount;
    }

    public void setActiveUserCount(Integer activeUserCount) {
        this.activeUserCount = activeUserCount;
    }

    public Integer getChatCount() {
        return chatCount;
    }

    public void setChatCount(Integer chatCount) {
        this.chatCount = chatCount;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    public Long getBuyUserNumber() {
        return buyUserNumber;
    }

    public void setBuyUserNumber(Long buyUserNumber) {
        this.buyUserNumber = buyUserNumber;
    }

    public Long getBuyCount() {
        return buyCount;
    }

    public void setBuyCount(Long buyCount) {
        this.buyCount = buyCount;
    }

    @Override
    public String toString() {
        return "BookGroupQrcodeStatisticVO{" +
                "groupQrcodeId=" + groupQrcodeId +
                ", weixinGroupId='" + weixinGroupId + '\'' +
                ", classifyId=" + classifyId +
                ", groupName='" + groupName + '\'' +
                ", groupUserNumber=" + groupUserNumber +
                ", joinUserNumberTotal=" + joinUserNumberTotal +
                ", joinUserNumberToday=" + joinUserNumberToday +
                ", activeUserCount=" + activeUserCount +
                ", chatCount=" + chatCount +
                ", income=" + income +
                ", buyUserNumber=" + buyUserNumber +
                ", buyCount=" + buyCount +
                '}';
    }
}
