package com.pcloud.book.pcloudkeyword.biz;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.dto.ClassifyWelcomeDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.book.pcloudkeyword.vo.ClassifyOpenStatusUpdateVO;
import com.pcloud.book.pcloudkeyword.vo.ClassifySeqNumUpdateVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface PcloudRobotClassifyBiz {

    /**
     * 查询所有小号分类
     */
    List<PcloudRobotClassifyResponseVO> listAllRobotClassify();

    /**
     * 新增分类
     */
    void saveRobotClassify(String classifyName);

    /**
     * 修改分类
     */
    void updateRobotClassify(PcloudRobotClassify classify);

    /**
     * 获取分类
     */
    PcloudRobotClassify getClassifyById(Long id);

    /**
     * 分页查询所有小号分类
     */
    PageBeanNew<PcloudRobotClassifyResponseVO> listClassifyByPage(Integer currentPage, Integer numPerPage,Boolean testShow);

    ClassifyWelcomeDTO getClassifyWelcome(Long classifyId,Integer robotType);

    void updateClassifyWelcome(ClassifyWelcomeDTO classifyWelcomeDTO);

    /**
     * 更新分类的关键词分类
     */
    void updateRobotClassifyKeywordClassify(PcloudRobotClassify classify);

    /**
     * 修改分类排序值
     * @param vo
     */
    void updateSeqNum4RobotClassify(ClassifySeqNumUpdateVO vo);

    void testSentry();

    RobotClassifyDTO getClassifyInfo(Long robotType);

    PageBeanNew<PcloudRobotClassifyResponseVO> listClassifyByPage4Mini(Integer currentPage, Integer numPerPage);

    void updateOpenStatus4RobotClassify(ClassifyOpenStatusUpdateVO vo);

    List<Long> getOpenTempletIds();
}
