package com.pcloud.book.pcloudkeyword.check;


import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordNameDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeyword;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordName;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordReply;
import com.pcloud.book.pcloudkeyword.entity.PcloudNotKeyword;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component("pcloudKeywordCheck")
public class PcloudKeywordCheck {

    @Autowired
    private PcloudKeywordNameDao pcloudKeywordNameDao;

    @ParamLog("新增关键词校验")
    public void createPcloudKeywordCheck(PcloudKeyword pcloudKeyword) {
        baseCheck(pcloudKeyword);
        List<String> names = pcloudKeywordNameDao.getNameListByClassifyId(pcloudKeyword.getKeywordClassifyId(), null);
        for (PcloudKeywordName name:pcloudKeyword.getPcloudKeywordNames()){
            if (name==null|| StringUtil.isEmpty(name.getName())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"名称为空！");
            }
            if (!ListUtils.isEmpty(names) && names.contains(name.getName())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"关键词“"+name.getName()+"”已存在");
            }
        }
        replyCheck(pcloudKeyword.getPcloudKeywordReplies());
    }

    private void baseCheck(PcloudKeyword pcloudKeyword){
        if (pcloudKeyword==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (pcloudKeyword.getMethod()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"方式1全部回复，2随机回复为空！");
        }
        if (pcloudKeyword.getType()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"类型1：精准，2模糊为空！");
        }
        if (pcloudKeyword.getKeywordClassifyId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"分类为空！");
        }
        if (ListUtils.isEmpty(pcloudKeyword.getPcloudKeywordNames())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"名称为空！");
        }
        if (ListUtils.isEmpty(pcloudKeyword.getPcloudKeywordReplies())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复为空！");
        }
        for (PcloudKeywordName name:pcloudKeyword.getPcloudKeywordNames()){
            if (name==null|| StringUtil.isEmpty(name.getName())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"名称为空！");
            }
        }
        List<String> names = pcloudKeyword.getPcloudKeywordNames().stream().filter(s->s.getName()!=null).map(PcloudKeywordName::getName).distinct().collect(Collectors.toList());
        if (names.size()< pcloudKeyword.getPcloudKeywordNames().size()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"关键词重复");
        }
    }
    private void replyCheck(List<PcloudKeywordReply> replyList){
        for (PcloudKeywordReply reply:replyList){
            if (reply==null){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复为空！");
            }
            if (reply.getReplyType()==null){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复类型为空！");
            }
            reply.setType(reply.getReplyType());
            if (ReplyTypeEnum.TEXT.value.equals(reply.getType())&&StringUtil.isEmpty(reply.getContent())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复内容为空！");
            }
            if (ReplyTypeEnum.IMAGE.value.equals(reply.getType())&&StringUtil.isEmpty(reply.getPicUrl())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复内容为空！");
            }
            if (ReplyTypeEnum.APP.value.equals(reply.getType())
                    &&(StringUtil.isEmpty(reply.getServeType())||reply.getServeId()==null)){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复应用类型或应用id为空！");
            }
            if (ReplyTypeEnum.RESOURCE.value.equals(reply.getType())&&reply.getResourceId()==null){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复资源id为空！");
            }
            if (ReplyTypeEnum.LINK.value.equals(reply.getType()) && StringUtil.isEmpty(reply.getLinkUrl())) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "链接地址不能为空！");
            }
        }
    }

    @ParamLog("修改关键词校验")
    public void updatePcloudKeywordCheck(PcloudKeyword pcloudKeyword) {
        if (pcloudKeyword==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (pcloudKeyword.getId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"id为空！");
        }
        baseCheck(pcloudKeyword);
        List<String> names = pcloudKeywordNameDao.getNameListByClassifyId(pcloudKeyword.getKeywordClassifyId(), pcloudKeyword.getId());
        for (PcloudKeywordName name:pcloudKeyword.getPcloudKeywordNames()){
            if (name==null|| StringUtil.isEmpty(name.getName())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"名称为空！");
            }
            if (!ListUtils.isEmpty(names) && names.contains(name.getName())){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"关键词“"+name.getName()+"”已存在");
            }
        }
        replyCheck(pcloudKeyword.getPcloudKeywordReplies());
    }

    /**
     * 非关键词新增校验
     * @param pcloudNotKeyword
     */
    public void createPcloudNotKeywordCheck(PcloudNotKeyword pcloudNotKeyword) {
        if (pcloudNotKeyword==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (pcloudNotKeyword.getMethod()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"方式1全部回复，2随机回复为空！");
        }
        if (pcloudNotKeyword.getKeywordClassifyId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"分类为空！");
        }
        if (ListUtils.isEmpty(pcloudNotKeyword.getPcloudKeywordReplies())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"回复为空！");
        }
        replyCheck(pcloudNotKeyword.getPcloudKeywordReplies());
    }

    /**
     * 非关键词修改校验
     * @param pcloudNotKeyword
     */
    public void updateNotPcloudKeywordCheck(PcloudNotKeyword pcloudNotKeyword) {
        if (pcloudNotKeyword==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (pcloudNotKeyword.getId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"id为空！");
        }
        createPcloudNotKeywordCheck(pcloudNotKeyword);
    }
}
