package com.pcloud.book.pcloudkeyword.dao.impl;


import com.pcloud.book.pcloudkeyword.dao.PcloudRobotMemoDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotMemo;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Component("pcloudRobotMemoDao")
public class PcloudRobotMemoDaoImpl extends BaseDaoImpl<PcloudRobotMemo> implements PcloudRobotMemoDao {


    @Override
    public List<PcloudRobotMemo> getMemoListByGroupId(Long groupId) {
        return this.getSessionTemplate().selectList(this.getStatement("getMemoListByGroupId"), groupId);
    }

    @Override
    public List<PcloudRobotMemo> getMemoByContext(String context) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("context", context);
        return this.getSessionTemplate().selectList(this.getStatement("getMemoByContext"), paramMap);
    }

    @Override
    public void updateById(PcloudRobotMemo pcloudRobotMemo) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", pcloudRobotMemo.getId());
        paramMap.put("context", pcloudRobotMemo.getContext());
        this.getSqlSession().update(this.getStatement("updateById"), paramMap);
    }

}
