package com.pcloud.book.personal.dao.impl;

import com.google.common.collect.Maps;
import com.pcloud.book.personal.dao.PersonalMedalDao;
import com.pcloud.book.personal.entity.PersonalMedal;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;

@Repository("personalMedalDao")
public class PersonalMedalDaoImpl extends BaseDaoImpl<PersonalMedal> implements PersonalMedalDao {
    @Override
    public List<PersonalMedal> getBaseMedalList() {
        return super.getSqlSession().selectList(getStatement("getBaseMedalList"));
    }

    @Override
    public List<Long> getReceivingMedal(Long wechatUserId, Integer starCount) {
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("wechatUserId", wechatUserId);
        map.put("starCount",starCount);
        return super.getSqlSession().selectList(getStatement("getReceivingMedal"), map);
    }
}
