package com.pcloud.book.personalstage.service.impl;

import com.pcloud.book.personalstage.biz.PersonalStageBiz;
import com.pcloud.book.personlstage.dto.UserReplaceCodeDTO;
import com.pcloud.book.personlstage.service.PersonalStageService;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController("personalStageService")
@RequestMapping("personalStageService")
public class PersonalStageServiceImpl implements PersonalStageService {

    @Autowired
    private PersonalStageBiz personalStageBiz;

    @ApiOperation("创建用户替换记录")
    @PostMapping("createUserReplaceCode")
    @Override
    public void createUserReplaceCode(
            @RequestBody @ApiParam("用户替换记录") UserReplaceCodeDTO userReplaceCodeDTO
    ) throws BizException {
        personalStageBiz.createUserReplaceCode(userReplaceCodeDTO);
    }

}
