package com.pcloud.book.personalstage.vo.request;

import com.pcloud.book.personalstage.entity.PersonalStageJumpEmail;
import com.pcloud.book.personalstage.entity.PersonalStageJumpKeyword;
import com.pcloud.book.personalstage.entity.PersonalStageJumpLinkup;
import com.pcloud.common.entity.BaseRequestVO;
import com.pcloud.common.utils.ListUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
public abstract class BaseStageJumpRequestVO extends BaseRequestVO {
    @NotNull(message = "阶段id不能为空")
    private Long personalStageId;

    @NotNull(message = "跳转类型不能为空")
    private Integer jumpType;

    private Long afterPersonalStageId;

    @NotNull(message = "未设置是否开启邮件提醒")
    private Boolean openEmail;

    private String transferMessage;

    private Double transferMoney;

    @ApiModelProperty("距离阶段开始时间")
    private Integer toStageStartTime;

    @NotNull(message = "跳转关键词不能为空")
    @Size(max = 5, message = "跳转关键词不能超过5个")
    private List<String> keywords;

    @Size(max = 5, message = "邮件地址不能超过5个")
    private List<String> emails;

    @Size(max = 5, message = "衔接语不能超过5个")
    private List<PersonalStageJumpLinkup> linkups;

    public static List<PersonalStageJumpKeyword> valueToJumpKeywords(BaseStageJumpRequestVO vo, Long personalStageJumpId){
        List<String> keywords = vo.getKeywords();
        if (ListUtils.isEmpty(keywords)){
            return new ArrayList<>();
        }
        List<PersonalStageJumpKeyword> jumpKeywords = new ArrayList<>();
        for (String keyword : keywords){
            PersonalStageJumpKeyword jumpKeyword = new PersonalStageJumpKeyword();
            jumpKeyword.setKeyword(keyword);
            jumpKeyword.setPersonalStageId(vo.getPersonalStageId());
            jumpKeyword.setPersonalStageJumpId(personalStageJumpId);
            jumpKeywords.add(jumpKeyword);
        }
        return jumpKeywords;
    }

    public static List<PersonalStageJumpEmail> valueToJumpEmails(BaseStageJumpRequestVO vo, Long personalStageJumpId){
        List<String> emails = vo.getEmails();
        if (ListUtils.isEmpty(emails)){
            return new ArrayList<>();
        }
        List<PersonalStageJumpEmail> jumpEmails = new ArrayList<>();
        for (String email : emails){
            PersonalStageJumpEmail jumpEmail = new PersonalStageJumpEmail();
            jumpEmail.setEmail(email);
            jumpEmail.setPersonalStageJumpId(personalStageJumpId);
            jumpEmails.add(jumpEmail);
        }
        return jumpEmails;
    }

    public static List<PersonalStageJumpLinkup> valueToJumpLinkups(BaseStageJumpRequestVO vo, Long personalStageJumpId){
        List<PersonalStageJumpLinkup> linkups = vo.getLinkups();
        if (ListUtils.isEmpty(linkups)){
            return new ArrayList<>();
        }
        List<PersonalStageJumpLinkup> jumpLinkups = new ArrayList<>();
        for (PersonalStageJumpLinkup linkup : linkups){
            PersonalStageJumpLinkup jumpLinkup = new PersonalStageJumpLinkup();
            jumpLinkup.setLinkupContent(linkup.getLinkupContent());
            jumpLinkup.setPersonalStageJumpId(personalStageJumpId);
            jumpLinkup.setToStageStartTime(linkup.getToStageStartTime());
            jumpLinkup.setReplyType((null == linkup.getReplyType() || linkup.getReplyType() == 0 ? 1 : linkup.getReplyType()));
            jumpLinkup.setPicUrl(linkup.getPicUrl());
            jumpLinkup.setResourceId(linkup.getResourceId());
            jumpLinkup.setPersonalAppletsId(linkup.getPersonalAppletsId());
            jumpLinkups.add(jumpLinkup);
        }
        return jumpLinkups;
    }
}
