package com.pcloud.book.reading.dao.impl;

import com.pcloud.book.reading.dao.ReadingInviteDao;
import com.pcloud.book.reading.entity.ReadingInvite;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @描述：邀请语设置
 * @作者：zhuyajie
 * @创建时间：17:29 2020/1/14
 * @版本：1.0
 */
@Component("readingInviteDao")
public class ReadingInviteDaoImpl extends BaseDaoImpl<ReadingInvite> implements ReadingInviteDao {

    @Override
    public List<ReadingInvite> getByActivityId(Long activityId) {
        return getSessionTemplate().selectList(getStatement("getByActivityId"), activityId);
    }

    @Override
    public void deleteByActivityId(Long activityId) {
        getSessionTemplate().delete(getStatement("deleteByActivityId"), activityId);
    }
}
