package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsSettingItemDao;
import com.pcloud.book.rightsSetting.entity.RightsSettingClassify;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：每周/长期权益(RightsSettingItem)表数据库访问层
 * @作者：zhuyajie
 * @创建时间：17:19 2020/4/19
 * @版本：1.0
 */
@Component
public class RightsSettingItemDaoImpl extends BaseDaoImpl<RightsSettingItem> implements RightsSettingItemDao {
    @Override
    public List<RightsSettingItem> queryAll(RightsSettingItem rightsSettingItem) {
        return getSessionTemplate().selectList(getStatement("queryAll"), rightsSettingItem);
    }

    @Override
    public int deleteByRightsSettingId(Long rightsSettingId,String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("rightsSettingId",rightsSettingId);
        map.put("rightsType", rightsType);
        return getSessionTemplate().delete(getStatement("deleteByRightsSettingId"), map);
    }

    @Override
    public List<RightsSettingClassify> getAllRightsClassify(String rightsType) {
        Map<String,Object> map = new HashMap<>();
        map.put("rightsType",rightsType);
        return getSessionTemplate().selectList(getStatement("getAllRightsClassify"), map);
    }
}
