package com.pcloud.book.rightsSetting.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import lombok.Data;

@Data
public class RightsSetting extends BaseTempletClassify {

    private String introduce;

    private String detail;

    private Integer count;

    private Long firstClassify;

    private Long secondClassify;

    private Long gradeLabelId;

    private Long subjectLabelId;

    @ApiModelProperty("线上网课是否开启")
    private Boolean onlineCourseOpen;

    @ApiModelProperty("学习工具是否开启")
    private Boolean learningToolOpen;

    @ApiModelProperty("抽奖是否开启")
    private Boolean drawNowOpen;


    @ApiModelProperty("线上网课集合")
    private List<RightsNowItem> onlineCourseNowItems;

    @ApiModelProperty("学习工具集合")
    private List<RightsNowItem> learningToolNowItems;

    @ApiModelProperty("抽奖集合")
    private List<RightsNowItem> drawNowItems;

    @ApiModelProperty("专享礼包券集合")
    private List<RightsNowItem> giftCouponPackageNowItems;

    @ApiModelProperty("启用专享社群服务")
    private Integer enableGroupService = 0;

    @ApiModelProperty("权益类型;【1分类权益、2书刊权益】")
    private Integer rightsSettingType = 1;

    @ApiModelProperty("书刊id")
    private Long bookId;

    /**
     * 书或isbn查询
     */
    private String bookQuery;
    /**
     * 书名
     */
    private String bookName;

    /**
     * 每周权益
     */
    private List<RightsSettingItem> rightsSettingWeekItems;

    /**
     * 长期权益
     */
    private List<RightsSettingItem> rightsSettingLongTermItems;
}