package com.pcloud.book.rightsSetting.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 每周/长期权益(RightsSettingItem)实体类
 *
 * @author zhuyajie
 * @since 2020-04-19 17:11:38
 */
@Data
public class RightsSettingItem extends BaseEntity {
    private static final long serialVersionUID = -10992603018190329L;
    
    private Long id;
    /**
    * 权益id
    */
    private Long rightsSettingId;
    /**
    * 权益类型（每周WEEK/长期LONG_TERM）
    */
    private String rightsType;
    /**
     * 权益分类
     */
    private Long rightsClassifyId;
    /**
    * 权益描述
    */
    private String description;
    /**
    * 创建时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    /**
     * 权益标题
     */
    private String title;
    /**
     * 资讯
     */
    private List<AppletNewsDTO> appletNewsDTOS;
}