package com.pcloud.book.timecontrol.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.Date;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TimeControlSelfPlanItem {

    private Integer id;

    private Integer selfPlanId;

    private Integer type;

    private String title;

    private String content;

    private String description;

    private String picUrl;

    private Integer openFeedback;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}