package com.pcloud.book.weixinclock.vo.request;

import com.pcloud.book.weixinclock.entity.WeixinClockCoupon;
import com.pcloud.common.entity.BaseRequestVO;
import com.pcloud.common.utils.bean.BeanUtils;

import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * @Describe: 优惠券请求vo
 * @Author: zhangdongwei
 * @Date: Create on 16:07 2019/11/12 0012
 */
@Data
public class CouponRequestVO extends BaseRequestVO {
    /**
     * 优惠券平台（淘宝、京东、当当）
     */
    @NotNull(message = "未选择优惠券平台")
    private Integer couponPlatform;
    /**
     * 商品名称
     */
    @NotNull(message = "未填写商品名称")
    private String title;
    /**
     * 商品图片
     */
    @NotNull(message = "没有商品图片")
    private String pictUrl;
    /**
     * 商品原始价格
     */
    @NotNull(message = "未填写商品原始价格")
    private BigDecimal proOriginPrice;
    /**
     * 优惠券价格
     */
    @NotNull(message = "未填写优惠券金额")
    private BigDecimal couponPrice;
    /**
     * 优惠券点击链接
     */
    @NotNull(message = "优惠券链接不能为空")
    private String couponClickUrl;
    /**
     * 领取优惠券天数
     */
    @NotNull(message = "未设置领取的打卡天数")
    private Integer dayNum;

    public static WeixinClockCoupon valueToEntity(CouponRequestVO vo){
        WeixinClockCoupon weixinClockCoupon = BeanUtils.copy(vo, WeixinClockCoupon.class);
        weixinClockCoupon.setAfterCouponPrice(vo.getProOriginPrice().subtract(vo.getCouponPrice()));
        weixinClockCoupon.setCreateUser(vo.getUserId());
        weixinClockCoupon.setUpdateUser(vo.getUserId());
        Date now = new Date();
        weixinClockCoupon.setCreateTime(now);
        weixinClockCoupon.setUpdateTime(now);
        return weixinClockCoupon;
    }

    public static CouponRequestVO valueOfEntity(WeixinClockCoupon weixinClockCoupon){
        CouponRequestVO vo = BeanUtils.copy(weixinClockCoupon, CouponRequestVO.class);
        return vo;
    }
}
