package com.pcloud.book.appeal.dto;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

/** 
  * 描述  :图书申诉结果Dto
  * @author 作者: lihao
  * @date 创建时间：2017年7月11日 下午6:39:32 
  * @version 1.0 
  */
public class BookAppealResultDto extends BaseDto{
   
	private static final long serialVersionUID = 2707885283670422638L;
	
	private Long id;

	/**
	 * 图书标识
	 */
	private Long bookId;

	/**
	 * 图书申诉标识
	 */
	private Long bookAppealId;

	/**
	 * 编辑名称
	 */
	private Long adviserId;
	
	/**
	 * 书籍创建时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date createdDate;
	
	/**
	 * 代理名称
	 */
	private String agentName;
	
	/**
	 * 编辑名称
	 */
	private String adviserName;
	
	/**
	 * 电话
	 */
	private String phone;
	
	/**
	 * 是否是主编辑
	 */
	private Boolean isMainEditor;

	/**
     * 编辑头像
     */
    private String headUrl;

	/**
	 * 运营标识
	 */
	private Long channelId;

	/**
	 * 运营名称
	 */
	private String channelName;

	/**
	 * 图书创建时间
	 */
	private Date bookCreatedDate;

	/**
	 * 是否申诉编辑
	 */
	private Boolean appealAdviser;


	public Long getAdviserId() {
		return adviserId;
	}

	public void setAdviserId(Long adviserId) {
		this.adviserId = adviserId;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getAgentName() {
		return agentName;
	}

	public void setAgentName(String agentName) {
		this.agentName = agentName;
	}

	public String getAdviserName() {
		return adviserName;
	}

	public void setAdviserName(String adviserName) {
		this.adviserName = adviserName;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public Boolean getIsMainEditor() {
		return isMainEditor;
	}

	public void setIsMainEditor(Boolean isMainEditor) {
		this.isMainEditor = isMainEditor;
	}

	public String getHeadUrl() {
		return headUrl;
	}

	public void setHeadUrl(String headUrl) {
		this.headUrl = headUrl;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getChannelId() {
		return channelId;
	}

	public void setChannelId(Long channelId) {
		this.channelId = channelId;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getBookCreatedDate() {
		return bookCreatedDate;
	}

	public void setBookCreatedDate(Date bookCreatedDate) {
		this.bookCreatedDate = bookCreatedDate;
	}

	public Long getBookId() {
		return bookId;
	}

	public void setBookId(Long bookId) {
		this.bookId = bookId;
	}

	public Long getBookAppealId() {
		return bookAppealId;
	}

	public void setBookAppealId(Long bookAppealId) {
		this.bookAppealId = bookAppealId;
	}

	public Boolean getAppealAdviser() {
		return appealAdviser;
	}

	public void setAppealAdviser(Boolean appealAdviser) {
		this.appealAdviser = appealAdviser;
	}

	@Override
	public String toString() {
		return "BookAppealResultDto{" +
				"id=" + id +
				", bookId=" + bookId +
				", bookAppealId=" + bookAppealId +
				", adviserId=" + adviserId +
				", createdDate=" + createdDate +
				", agentName='" + agentName + '\'' +
				", adviserName='" + adviserName + '\'' +
				", phone='" + phone + '\'' +
				", isMainEditor=" + isMainEditor +
				", headUrl='" + headUrl + '\'' +
				", channelId=" + channelId +
				", channelName='" + channelName + '\'' +
				", bookCreatedDate=" + bookCreatedDate +
				", appealAdviser=" + appealAdviser +
				'}';
	}
}
