package com.pcloud.book.clock.eneity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author: hzk
 * @Date: 2019/6/6 11:29
 * @Version 1.0
 */
public class BookClockKeywordCheckParam extends BaseEntity {

    private static final long serialVersionUID = -2920073442893221261L;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("编辑ID")
    private Long adviserId;

    @ApiModelProperty("微信群打卡ID")
    private Long bookClockInfoId;

    @ApiModelProperty("是否为书重复")
    private Boolean isBookGroup;

    @ApiModelProperty("已选社群书ID集合")
    private List<Long> bookGroupIdList;

    @ApiModelProperty("已选分类ID集合")
    private List<Long> classifyIdList;

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页个数")
    private Integer numPerPage;

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public List<Long> getBookGroupIdList() {
        return bookGroupIdList;
    }

    public void setBookGroupIdList(List<Long> bookGroupIdList) {
        this.bookGroupIdList = bookGroupIdList;
    }

    public List<Long> getClassifyIdList() {
        return classifyIdList;
    }

    public void setClassifyIdList(List<Long> classifyIdList) {
        this.classifyIdList = classifyIdList;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public Boolean getIsBookGroup() {
        return isBookGroup;
    }

    public void setIsBookGroup(Boolean isBookGroup) {
        this.isBookGroup = isBookGroup;
    }

    @Override
    public String toString() {
        return "BookClockKeywordCheckParam{" +
                "keyword='" + keyword + '\'' +
                ", adviserId=" + adviserId +
                ", bookClockInfoId=" + bookClockInfoId +
                ", isBookGroup=" + isBookGroup +
                ", bookGroupIdList=" + bookGroupIdList +
                ", classifyIdList=" + classifyIdList +
                ", currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                '}';
    }
}
