package com.pcloud.book.copyright.service;

import com.pcloud.book.copyright.dto.BookAuthInfoCountDTO;
import com.pcloud.book.copyright.dto.BookAuthTotalCountDTO;
import com.pcloud.book.copyright.dto.CheckUserAuthDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lily
 * @date 2018/12/4 16:23
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAuthInfoServiceCloud", path = "book/v1.0/bookAuthInfoService")
@Api(description = "图书版权开启信息")
public interface BookAuthInfoService {

    @ApiOperation(value = "获取图书授权金价格", httpMethod = "GET")
    @RequestMapping(value = "/getBookAuthPrice", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BigDecimal>> getBookAuthPrice(@RequestParam("bookId") Long bookId, @RequestParam("channelId")Long channelId,
                                                             @RequestParam("adviserId")Long adviserId) throws BizException;

    @ApiOperation(value = "获取图书授权统计信息", httpMethod = "GET")
    @RequestMapping(value = "/getBookAuthInfoCount", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookAuthInfoCountDTO>> getBookAuthInfoCount(@RequestParam("bookId") Long bookId, @RequestParam("channelId")Long channelId,
                                                                           @RequestParam("adviserId")Long adviserId, @RequestParam("monthDate") String monthDate) throws BizException;

    @ApiOperation(value = "获取图书授权总统计信息", httpMethod = "GET")
    @RequestMapping(value = "/getBookAuthTotalCount", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookAuthTotalCountDTO>> getBookAuthTotalCount() throws BizException;

    @ApiOperation(value = "根据获取图书授权总统计信息", httpMethod = "POST")
    @RequestMapping(value = "/getBookAuthTotalCount4Adviser", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<BookAuthTotalCountDTO>> getBookAuthTotalCount4Adviser(@RequestBody List<Long> adviserIds) throws BizException;

    @ApiOperation(value = "校验用户是否授权过（进群）", httpMethod = "POST")
    @RequestMapping(value = "/checkUserIsHaveAuth", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Boolean>> checkUserIsHaveAuth(@RequestBody CheckUserAuthDTO checkUserAuthDTO) throws BizException;

    @ApiOperation(value = "获取社群书授权金价格", httpMethod = "GET")
    @RequestMapping(value = "/getGroupBookAuthPrice", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BigDecimal>> getGroupBookAuthPrice(@RequestParam("bookId") Long bookId, @RequestParam("channelId")Long channelId,
                                                             @RequestParam("adviserId")Long adviserId) throws BizException;


}
