package com.pcloud.book.timecontrol.service;

import com.pcloud.book.timecontrol.dto.BookTaskBindingDto;
import com.pcloud.book.timecontrol.dto.LabelDto;
import com.pcloud.book.timecontrol.dto.TaskDto;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Description：TODO
 * @Author：zcy
 * @Date：2020-01-30
 * @Version：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "timeControlTaskServiceCloud", path = "/book/v1.0/timeControlTaskService")
@Api(description = "时间管理内部接口")
public interface TimeControlTaskService {

    @ApiOperation(value = "定时发送任务消息", httpMethod = "GET")
    @GetMapping("sendTimeTaskMessage")
    void sendTimeTaskMessage();

    @ApiOperation(value = "获取任务信息")
    @GetMapping("getTaskById")
    ResponseEntity<ResponseDto<TaskDto>> getTaskById(@RequestParam(value = "taskId") Integer taskId);

    @ApiOperation("获取任务列表")
    @GetMapping("listTask")
    ResponseEntity<ResponseDto<List<BookTaskBindingDto>>> listTask(@RequestParam(value = "search", required = false) String search);

    @ApiOperation(value = "批量获取任务信息", httpMethod = "POST")
    @PostMapping("getTaskBatch")
    ResponseEntity<ResponseDto<Map<Integer, TaskDto>>> getTaskBatch(@RequestBody List<Integer> taskIds);

    @ApiOperation(value = "获取最多的几个深度标签", httpMethod = "GET")
    @GetMapping("listMaxDepLabel")
    ResponseEntity<ResponseDto<List<LabelDto>>> listMaxDepLabel(@RequestParam(value = "num", required = false) Integer num);

    @ApiOperation(value = "用户通过关键词查找任务列表", httpMethod = "GET")
    @GetMapping("listTaskByKey4User")
    ResponseEntity<ResponseDto<List<TaskDto>>> listTaskByKey4User(@RequestParam("wxUserId") String wxUserId, @RequestParam("search") String search);

    @ApiOperation(value = "用户通过taskIds获取任务列表", httpMethod = "POST")
    @PostMapping("listTaskByIds4User")
    ResponseEntity<ResponseDto<List<TaskDto>>> listTaskByIds4User(@RequestParam("wxUserId") String wxUserId, @RequestBody List<Integer> taskIds);

    @ApiOperation(value = "用户通过标签获取任务列表", httpMethod = "GET")
    @GetMapping("listTaskByLabelIds4User")
    ResponseEntity<ResponseDto<List<TaskDto>>> listTaskByLabelIds4User(@RequestParam("wxUserId") String wxUserId, @RequestParam(value = "labelId") Long labelId);

    @ApiOperation(value = "订阅任务")
    @GetMapping("unSubscribeTask")
    void unSubscribeTask(@RequestParam("wxId") String wxId, @RequestParam("taskId") Integer taskId);
}