package com.pcloud.book.adnews.dao.impl;

import com.pcloud.book.adnews.dao.AdNewsGroupRecordDao;
import com.pcloud.book.adnews.entity.AdNewsGroupRecord;
import com.pcloud.book.adnews.vo.AdNewsGroupRecordVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 16:18
 **/
@Repository("adNewsGroupRecordDao")
public class AdNewsGroupRecordDaoImpl extends BaseDaoImpl<AdNewsGroupRecord> implements AdNewsGroupRecordDao {
    @Override
    public Integer batchInsert(List<AdNewsGroupRecord> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<AdNewsGroupRecordVO> getAdNewsGroupRecord(Long partyId, Long messageStatisticId) {
        Map<String,Object> map = new HashMap<>();
        map.put("partyId",partyId );
        map.put("messageStatisticId",messageStatisticId );
        return super.getSqlSession().selectList(getStatement("getAdNewsGroupRecord"),map);
    }
}
