package com.pcloud.book.adnews.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 15:55
 **/
@ApiModel("编辑新闻发送记录")
@Data
public class AdNewsGroupRecord extends BaseEntity{

    private static final long serialVersionUID = -3271071194854381077L;

    @ApiModelProperty("消息统计表id")
    private Long messageStatisticId;

    @ApiModelProperty("群id")
    private Long qrcodeId;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("编辑新闻id")
    private Long adNewsId;

    @ApiModelProperty("编辑新闻设置id")
    private Long adNewsSetId;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @ApiModelProperty("自定义内容")
    private String customContent;

    @ApiModelProperty("内容类型，0：早报；1：晚报")
    private Integer contentType;

    @ApiModelProperty(value = "内容来源；0：来源于公众号；1：自定义早晚报；2：自有公众号；",dataType = "com.pcloud.book.adnews.enums.AdContentFromEnum")
    private Integer contentFrom;

    @ApiModelProperty("insert时父子表标识")
    Integer insertMark;
}
