package com.pcloud.book.advertising.biz;

import com.pcloud.book.advertising.dto.AdvertisingBrandDTO;
import com.pcloud.book.advertising.dto.Book4AdvertisingTagDTO;
import com.pcloud.book.advertising.dto.GroupTagAddDTO;
import com.pcloud.book.advertising.dto.GroupTagDTO;
import com.pcloud.book.advertising.entity.AdvertisingBrand;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @描述：微信群标记品牌方
 * @作者：zhuyajie
 * @创建时间：18:47 2019/8/22
 * @版本：1.0
 */
public interface GroupTagBiz {

    /**
     * 微信群品牌标记列表
     * @param currentPage
     * @param numPerPage
     * @param paramMap
     * @return
     */
    PageBeanNew<GroupTagDTO> listPageGroup4Brand(Integer currentPage, Integer numPerPage, Map<String, Object> paramMap);

    /**
     * 获取品牌方
     * @return
     * @throws BizException
     */
    List<AdvertisingBrandDTO> getAllBrand() throws BizException;

    /**
     * 微信群标记品牌方
     * @param groupTagAddDTO
     */
    void setGroupBrand(GroupTagAddDTO groupTagAddDTO);

    /**
     * 品牌标记-图书列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBeanNew<Book4AdvertisingTagDTO> listPageBook4AdBrand(Integer currentPage, Integer numPerPage, String name);

    /**
     * 品牌方-微信群列表
     * @param userId
     * @param currentPage
     * @param numPerPage
     * @param paramMap
     * @return
     */
    PageBeanNew<GroupTagDTO> listPageGroupList4Brand(Long userId, Integer currentPage, Integer numPerPage, Map<String, Object> paramMap);

    /**
     * 微信群品牌方标记列表-导出
     * @param name
     * @param proLabelId
     * @param depLabelId
     * @param purLabelId
     * @param brandId
     */
    void exportGroupBrand(String name, Long proLabelId, Long depLabelId, Long purLabelId, Long brandId, Long partyId);

    /**
     * 品牌方-微信群导出
     * @param userId
     * @param paramMap
     */
    Map<String,Object> exportGroupList4Brand(Map<String, Object> paramMap, Long userId);

    /**
     * 根据登录用户获取标记的微信群列表
     * @param userId
     * @return
     */
    List<String> getTagWxGroupIdsByUserId(Long userId);

    /**
     * 品牌方-微信群基本信息列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @param userId
     * @return
     */
    PageBeanNew<GroupTagDTO> listPageGroupBaseInfo4Brand(Integer currentPage, Integer numPerPage, String name, Long userId);

    /**
     * 品牌方已标记的书刊id
     * @param brandId
     * @return
     */
    List<Long> getTagBookIds4AdBrand(Long brandId);

    /**
     * 已标记的书标记新的群
     * @param classifyId
     * @param qrcodeId
     */
    public void addTagByBookGroup(Long classifyId, Long qrcodeId);

    /**
     * 创建品牌方账号
     * @param advertisingBrand
     * @return
     */
    Long createBrand(AdvertisingBrand advertisingBrand);

    /**
     * 根据id查品牌方信息（明文密码）
     * @param brandId
     * @return
     */
    AdvertisingBrandDTO getBrandById(Long brandId);

    /**
     * 修改品牌方密码
     * @param advertisingBrand
     */
    void updateBrandPassword(AdvertisingBrand advertisingBrand);

    /**
     * 根据id删除品牌方
     * @param brandId
     */
    void deleteBrandById(Long brandId);

    /**
     * 分页查询品牌方
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBean listPageBrand(Integer currentPage, Integer numPerPage, String name);

    /**
     * 品牌方登录
     * @param advertisingBrandDTO
     * @return
     */
    Map<String,Object> brandLogin(AdvertisingBrandDTO advertisingBrandDTO);
    /**
     * 查微信群标记的品牌方id
     * @param wxGroupId
     * @return
     */
    List<Long> getBrandIdsByWxGroupId(String wxGroupId);
    /**
     * 品牌方旧数据处理
     */
    void dealOldBrandStatistic();

    /**
     * 获取品牌方登录信息
     * @param userId
     * @return
     */
    Map<String,Object> getBrandLoginInfo(Long userId);
}
