package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingDetailFile;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：广告详情上传文件
 * @作者：zhuyajie
 * @创建时间：21:16 2019/8/2
 * @版本：1.0
 */
public interface AdvertisingDetailFileDao extends BaseDao<AdvertisingDetailFile> {

    /**
     * 根据广告id查询
     * @param cpaId
     * @return
     */
    public List<AdvertisingDetailFile> getByCPAId(Long cpaId);

    /**
     * 删除文件
     * @param cpaId
     */
    void deleteByCPAId(Long cpaId);

    /**
     * 更新cpaId
     * @param adId
     * @param cpaId
     */
    void updateCPAId(Long adId, Long cpaId);
}
