package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingBrowseRecordDao;
import com.pcloud.book.advertising.entity.AdvertisingBrowseRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @描述：浏览记录
 * @作者：zhuyajie
 * @创建时间：17:20 2019/7/11
 * @版本：1.0
 */
@Component("advertisingBrowseRecordDao")
public class AdvertisingBrowseRecordDaoImpl extends BaseDaoImpl<AdvertisingBrowseRecord> implements AdvertisingBrowseRecordDao {

    @Override
    public void addBrowseTimesByRecordId(String recordId, Long browseTimes) {
        Map<String, Object> map = new HashMap<>();
        map.put("recordId", recordId);
        map.put("browseTimes", browseTimes);
        getSessionTemplate().update(getStatement("addBrowseTimesByRecordId"), map);
    }

    @Override
    public Long getBrowseTimesByQrcode(Long qrcodeId, Long adId, String statisMonth) {
        Map<String, Object> map = new HashMap<>();
        map.put("qrcodeId", qrcodeId);
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getBrowseTimesByQrcode"), map);
    }

    @Override
    public Long getBrowseUserCountByQrcode(Long qrcodeId, Long adId, String statisMonth) {
        Map<String, Object> map = new HashMap<>();
        map.put("qrcodeId", qrcodeId);
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getBrowseUserCountByQrcode"), map);
    }

    @Override
    public Long getBrowseTimesByBook(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("adviserId", adviserId);
        paramMap.put("channelId", channelId);
        paramMap.put("adId", adId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getBrowseTimesByBook"), paramMap);
    }

    @Override
    public Long getBrowseUserCountByBook(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("adviserId", adviserId);
        paramMap.put("channelId", channelId);
        paramMap.put("adId", adId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getBrowseUserCountByBook"), paramMap);
    }
}
