package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingDetailFileDao;
import com.pcloud.book.advertising.entity.AdvertisingDetailFile;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：广告详情上传文件
 * @作者：zhuyajie
 * @创建时间：21:17 2019/8/2
 * @版本：1.0
 */
@Component("advertisingDetailFileDao")
public class AdvertisingDetailFileDaoImpl extends BaseDaoImpl<AdvertisingDetailFile> implements AdvertisingDetailFileDao {

    @Override
    public List<AdvertisingDetailFile> getByCPAId(Long cpaId) {
        return getSessionTemplate().selectList(getStatement("getByCPAId"), cpaId);
    }

    @Override
    public void deleteByCPAId(Long cpaId) {
        getSessionTemplate().delete(getStatement("deleteByCPAId"), cpaId);
    }

    @Override
    public void updateCPAId(Long adId, Long cpaId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("cpaId", cpaId);
        getSessionTemplate().update(getStatement("updateCPAId"), map);
    }
}
