package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

/**
 * @描述：链接转换记录
 * @作者：zhuyajie
 * @创建时间：17:13 2019/10/10
 * @版本：1.0
 */
public class LinkRevertRecordDTO extends BaseDto {

    /**
     * 记录id
     */
    private Long id;
    /**
     *品牌方id
     */
    private Long brandId;

    /**
     * 品牌方名称
     */
    private String brandName;
    /**
     *原链接
     */
    private String link;
    /**
     *短链接
     */
    private String shortLink;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 发送次数
     */
    private Integer sendCount;
    /**
     * 点击次数
     */
    private Integer clickCount;
    /**
     * 点击人数
     */
    private Integer clickUserCount;

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getShortLink() {
        return shortLink;
    }

    public void setShortLink(String shortLink) {
        this.shortLink = shortLink;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getSendCount() {
        return sendCount;
    }

    public void setSendCount(Integer sendCount) {
        this.sendCount = sendCount;
    }

    public Integer getClickCount() {
        return clickCount;
    }

    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    public Integer getClickUserCount() {
        return clickUserCount;
    }

    public void setClickUserCount(Integer clickUserCount) {
        this.clickUserCount = clickUserCount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "LinkRevertRecordDTO{" +
                "id=" + id +
                ", brandId=" + brandId +
                ", brandName='" + brandName + '\'' +
                ", link='" + link + '\'' +
                ", shortLink='" + shortLink + '\'' +
                ", createTime=" + createTime +
                ", sendCount=" + sendCount +
                ", clickCount=" + clickCount +
                ", clickUserCount=" + clickUserCount +
                '}';
    }
}
