package com.pcloud.book.book.facade.impl;

import com.pcloud.book.book.biz.BookTempletFeedbackBiz;
import com.pcloud.book.book.facade.BookTempletFeedbackFacade;
import com.pcloud.book.book.vo.FeedbackParam;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lily
 * @date 2018/10/31 15:42
 */
@RequestMapping("/bookTempletFeedback")
@RestController("bookTempletFeedbackFacade")
public class BookTemplateFeedbackFacadeImpl implements BookTempletFeedbackFacade {

    @Autowired
    private BookTempletFeedbackBiz bookTempletFeedbackBiz;

    @Override
    @RequestMapping(value = "create", method = RequestMethod.POST)
    public ResponseDto<?> create(@RequestHeader("token") String token, @RequestBody  FeedbackParam feedbackParam) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookTempletFeedbackBiz.create(feedbackParam, adviserId);
        return new ResponseDto<>();
    }
}
