/**
 * 
 */
package com.pcloud.book.book.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.pcloud.book.book.biz.BookAppBiz;
import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.book.book.entity.BookApp;
import com.pcloud.book.book.service.BookAppService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * @描述：编辑推广书籍接口类实现类
 * @作者：songx
 * @创建时间：2017年1月4日,下午7:59:13 @版本：1.0
 */
@RestController("bookAppService")
@RequestMapping("bookAppService")
public class BookAppServiceImpl implements BookAppService {

	@Autowired
	private BookAppBiz bookAppBiz;

	@Override
	@RequestMapping(value = "/listBookApp", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Map<Long, BookAppDto>>> listBookApp(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId,
			@RequestParam(value = "adviserId", required = false) Long adviserId) {
		BookApp bookApp = new BookApp();
		bookApp.setBookId(bookId);
		bookApp.setChannelId(channelId);
		bookApp.setCreatedUser(adviserId);
		List<BookAppDto> bookAppDtos = bookAppBiz.listBaseById(bookApp);
		if (!ListUtils.isEmpty(bookAppDtos)) {
			Map<Long, BookAppDto> map = new HashMap<Long, BookAppDto>();
			for (BookAppDto bookAppDto : bookAppDtos) {
				map.put(bookAppDto.getAppId(), bookAppDto);
			}
			return ResponseHandleUtil.toResponse(map);
		}
		return null;
	}

	@Override
	@RequestMapping(value = "/createBatch", method = RequestMethod.POST)
	public void createBatch(@RequestBody(required = false) List<Long> bookIds,
			@RequestParam(value = "channelId", required = false) Long channelId,
			@RequestParam(value = "appId", required = false) Long appId,
			@RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException {
		bookAppBiz.createBatch(bookIds, channelId, appId, adviserId);
	}
}
