/**
 * 
 */
package com.pcloud.book.book.service.impl;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.pcloud.book.book.biz.BookProductBiz;
import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.book.book.service.BookProductService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2016年12月23日,下午4:37:11 @版本：1.0
 */
@RestController("bookProductService")
@RequestMapping("bookProductService")
public class BookProductServiceImpl implements BookProductService {

	@Autowired
	private BookProductBiz BookProductBiz;

	/**
	 * 获取书籍关联的作品
	 */
	@Override
	@RequestMapping(value = "/getMapById", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Map<Long, BookProductDto>>> getMapById(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "adviserId", required = false) Long adviserId,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		Map<Long, BookProductDto> bookProductsMap = BookProductBiz.getMapById(bookId, adviserId, channelId);
		return ResponseHandleUtil.toResponse(bookProductsMap);
	}

}
