package com.pcloud.book.book.vo.request;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.entity.KeywordWarehouse;
import com.pcloud.book.book.entity.KeywordWarehouseDetail;
import com.pcloud.book.book.vo.BookKeywordDetailVO;
import com.pcloud.book.book.vo.KeywordWearhouseLabelVO;
import com.pcloud.common.entity.BaseRequestVO;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
@ApiModel
public class AddBookKeywordRequestVO extends BaseRequestVO {
    private static final long serialVersionUID = -5581508584274149498L;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("匹配规则（0：精准匹配1：模糊匹配）")
    private Integer matchingRule;

    @ApiModelProperty("适用范围（0：所有出版社,1：编辑）")
    private Integer scope;

    @ApiModelProperty("审核状态(0：手动添加免审核 1：申请待审核 2：审核通过 3：拒绝审核)")
    private Integer auditStatus;

    @ApiModelProperty("编辑id（适用范围为所有出版社的时候可以为空）")
    private Long editorId;

    @ApiModelProperty("关键词详情")
    private List<BookKeywordDetailVO> details;

    public KeywordWarehouse getEntity() {
        final KeywordWarehouse warehouse = new KeywordWarehouse();
        BeanUtils.copyProperties(this, warehouse);
        final Date now = new Date();
        warehouse.setEditorId(null == this.getEditorId() ? 0L : this.getEditorId());
//        warehouse.setAuditStatus(null == this.getAuditStatus() ? BookConstant.BookKeywordAuditEnum.NORMAL.getCode() : BookConstant.BookKeywordAuditEnum.TO_AUDIT.getCode());
        warehouse.setAuditStatus(null == this.getAuditStatus() ? BookConstant.BookKeywordAuditEnum.NORMAL.getCode() : BookConstant.BookKeywordAuditEnum.PASS_THE_AUDIT.getCode());
        warehouse.setCreateUser(this.getUserId());
        warehouse.setUpdateUser(this.getUserId());
        warehouse.setCreateTime(now);
        warehouse.setUpdateTime(now);
        warehouse.setIsDelete(0);
        return warehouse;
    }

    public List<KeywordWarehouseDetail> getDetailEntity(Long keywordId) {
        final List<KeywordWarehouseDetail> list = Lists.newArrayList();
        List<BookKeywordDetailVO> details = this.getDetails();
        if(CollectionUtils.isEmpty(details)) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "关键词信息为空");
        }
        Map<Integer, String> map = Maps.newHashMap();
        for (BookKeywordDetailVO vo : details) {
            final List<KeywordWearhouseLabelVO> labels = vo.getLabels();
            if("PRODUCT".equals(vo.getProductType()) && null == vo.getChannelId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "渠道信息不能为空");
            }
            if(CollectionUtils.isEmpty(labels)) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "标签信息为空");
            }
            for (KeywordWearhouseLabelVO label : labels) {
                KeywordWarehouseDetail detail = new KeywordWarehouseDetail();
                BeanUtils.copyProperties(vo, detail);
                String uuid = map.get(vo.getGroupId());
                if (StringUtil.isBlank(uuid)) {
                    uuid = StringUtil.getUUID();
                    map.put(vo.getGroupId(), uuid);
                }
                // 分组id唯一
                detail.setGroupId(uuid);
                detail.setProfessionalLabelId(label.getProfessionalLabelId());
                detail.setPurposeLabelId(label.getPurposeLabelId());
                detail.setDepthLabelId(label.getDepthLabelId());
                final Date now = new Date();
                detail.setKeywordId(keywordId);
                detail.setUseNum(0);
                detail.setCreateUser(this.getUserId());
                detail.setUpdateUser(this.getUserId());
                detail.setCreateTime(now);
                detail.setUpdateTime(now);
                detail.setIsDelete(0);
                list.add(detail);
            }
        }
        return list;
    }

    public Boolean check() {
        return CollectionUtils.isEmpty(this.getDetails())
                || StringUtil.isBlank(this.getKeyword())
                || StringUtil.isBlank(this.getGuide())
                || null == this.getMatchingRule()
                || null == this.getScope()
                || null == this.getUserId()
                || (scope != 0 && null == this.getEditorId());
    }

}
