package com.pcloud.book.clock.entity;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:52
 * @Version 1.0
 */
public class BookGroupClock extends BaseEntity {

    private static final long serialVersionUID = 8385194135258376669L;

    @ApiModelProperty("ID")
    private Long bookGroupClockId;

    @ApiModelProperty("作品/应用ID")
    private Long bookClockInfoId;

    @ApiModelProperty("书籍ID")
    private Long bookId;

    @ApiModelProperty("社群码ID")
    private Long bookGroupId;

    @ApiModelProperty("书ID集合")
    private List<Long> bookGroupIdList;

    @ApiModelProperty("分类ID")
    private Long classifyId;

    @ApiModelProperty("渠道ID")
    private Long channelId;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    public Long getBookGroupClockId() {
        return bookGroupClockId;
    }

    public void setBookGroupClockId(Long bookGroupClockId) {
        this.bookGroupClockId = bookGroupClockId;
    }

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }
}
