package com.pcloud.book.consumer.analysisengine;

import com.pcloud.analysisengine.wechatgroupan.dto.GroupBrowseDTO;
import com.pcloud.analysisengine.wechatgroupan.service.WechatGroupAnService;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/25 10:09
 **/
@Component("wechatGroupAnConsr")
public class WechatGroupAnConsr {
    private static final Logger LOGGER = LoggerFactory.getLogger(WechatGroupAnConsr.class);


    @Autowired
    private WechatGroupAnService wechatGroupAnService;

    @ParamLog(description = "获取微信群浏览集合")
    public List<GroupBrowseDTO> getGroupBrowseList(Long qrcodeId) {
        List<GroupBrowseDTO> groupBrowseDTOS = new ArrayList<>();
        try {
            groupBrowseDTOS = ResponseHandleUtil.parseListResponse(wechatGroupAnService.getGroupBrowseList(qrcodeId), GroupBrowseDTO.class);
        } catch (BizException e) {
            LOGGER.warn("【分析引擎(消)】获取微信群浏览集合.[getGroupBrowseList]:" + e.getMessage(), e);
        } catch (Exception e) {
            LOGGER.error("【分析引擎(消)】获取微信群浏览集合.[getGroupBrowseList]:" + e.getMessage(), e);
        }
        if (groupBrowseDTOS == null) {
            groupBrowseDTOS = new ArrayList<>();
        }
        return groupBrowseDTOS;
    }

    @ParamLog(description = "获取微信群单个浏览")
    public GroupBrowseDTO getGroupBrowseForOne(Long qrcodeId, Long wechatUserId) {
        GroupBrowseDTO groupBrowseDTO = new GroupBrowseDTO();
        try {
            groupBrowseDTO = ResponseHandleUtil.parseResponse(wechatGroupAnService.getGroupBrowseForOne(qrcodeId, wechatUserId), GroupBrowseDTO.class);
        } catch (BizException e) {
            LOGGER.warn("【分析引擎(消)】获取微信群单个浏览.[getGroupBrowseForOne]:" + e.getMessage(), e);
        } catch (Exception e) {
            LOGGER.error("【分析引擎(消)】获取微信群单个浏览.[getGroupBrowseForOne]:" + e.getMessage(), e);
        }
        if (groupBrowseDTO == null) {
            groupBrowseDTO = new GroupBrowseDTO();
        }
        return groupBrowseDTO;
    }

}
